#include "core.h"
#include "process.h"
#include "master.h"
#include "dbmonitor/dbmonitor.h"
#include "rt.h"
#include "unix.h"
SRCFILE("unixwd.c")

#define	K	DB_KERNELID

UnixWd::UnixWd(int f, int b)
{
	fd = f;
	bd = b;
}

void UnixWd::open() {
	char c[DB_MAX_SIZE];

	if (pad) {
		pad->makecurrent();
		return;
	}
	dbrequest(fd, bd, K, DBR_GETBNAME, (int)c, 0, sizeof(c));
	pad = new Pad((PadRcv*) this);
	pad->options(ACCEPT_KBD);
	pad->name("%s:cd", c);
	pad->banner("%s:Working Directory", c);
	prevwd = 0;
	pwd();
	pad->makecurrent();
}

Index UnixWd::carte()
{
	Menu m;
	char *cp;
	char c[DB_MAX_SIZE];

	while(!dbrequest(fd, bd, K, DBR_GETDIRS, (int)c, 0, sizeof(c))) {
		for (cp = c;;) {
			if (!*cp)
				return m.index();
			if (*cp == 1)
				break;
			long opand = (long) sf("%s/%s", wd, cp);
			m.sort(sf("%s\240", cp), (Action)&UnixWd::kbd, opand);
			cp += strlen(cp) + 1;
		}
	}
	return m.index();
}

char *UnixWd::getwd()
{
	char c[DB_MAX_SIZE];
	dbrequest(fd, bd, K, DBR_GETWD, (int)c, 0, sizeof(c));
	return sf("%s", c);
}

char *UnixWd::help(long l)
{
	switch(l) {
		case HELP_OVERVIEW:	return "Remote Directory Window";
		case HELP_MENU:		return "Directory Menu Bar";
		case HELP_KEY:		return "Directory Keyboard";
		case HELP_LMENU:	return "Directory Line Menus";
		default:		return 0;
	}
}

char *UnixWd::kbd(char *s)
{
	if( s[0]=='c' && s[1]=='d' && (s[2]==' '||s[2]==0) ) s += 2;
	while( *s == ' ' ) ++s;
	if (dbrequest(fd, bd, K, DBR_CD, (int)s, 0, strlen(s)+1)) {
		pad->insert(key++, "cannot cd %s", s);
		prevwd = 0;
	}
	pwd(SELECTLINE);
	return 0;
}

void UnixWd::pwd(Attrib a)
{
	if( prevwd )
		pad->insert(key, a, (PadRcv*)this, ix, "%s", wd);
	wd = getwd();
	ix = carte();
	pad->menu(ix);
	pad->insert(++key, a|DONT_CUT, (PadRcv*)this, ix, "wd=%s", wd);
	prevwd = wd;
}
